/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.lib.sentry;

import dev.tr7zw.lib.sentry.ILogger;
import dev.tr7zw.lib.sentry.JsonDeserializer;
import dev.tr7zw.lib.sentry.JsonObjectDeserializer;
import dev.tr7zw.lib.sentry.ObjectReader;
import dev.tr7zw.lib.sentry.SentryLevel;
import dev.tr7zw.lib.sentry.vendor.gson.stream.JsonReader;
import dev.tr7zw.lib.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class JsonObjectReader
implements ObjectReader {
    @NotNull
    private final JsonReader jsonReader;

    public JsonObjectReader(Reader in) {
        this.jsonReader = new JsonReader(in);
    }

    @Override
    @Nullable
    public String nextStringOrNull() throws IOException {
        if (this.jsonReader.peek() == JsonToken.NULL) {
            this.jsonReader.nextNull();
            return null;
        }
        return this.jsonReader.nextString();
    }

    @Override
    @Nullable
    public Double nextDoubleOrNull() throws IOException {
        if (this.jsonReader.peek() == JsonToken.NULL) {
            this.jsonReader.nextNull();
            return null;
        }
        return this.jsonReader.nextDouble();
    }

    @Override
    @Nullable
    public Float nextFloatOrNull() throws IOException {
        if (this.jsonReader.peek() == JsonToken.NULL) {
            this.jsonReader.nextNull();
            return null;
        }
        return Float.valueOf(this.nextFloat());
    }

    @Override
    public float nextFloat() throws IOException {
        return (float)this.jsonReader.nextDouble();
    }

    @Override
    @Nullable
    public Long nextLongOrNull() throws IOException {
        if (this.jsonReader.peek() == JsonToken.NULL) {
            this.jsonReader.nextNull();
            return null;
        }
        return this.jsonReader.nextLong();
    }

    @Override
    @Nullable
    public Integer nextIntegerOrNull() throws IOException {
        if (this.jsonReader.peek() == JsonToken.NULL) {
            this.jsonReader.nextNull();
            return null;
        }
        return this.jsonReader.nextInt();
    }

    @Override
    @Nullable
    public Boolean nextBooleanOrNull() throws IOException {
        if (this.jsonReader.peek() == JsonToken.NULL) {
            this.jsonReader.nextNull();
            return null;
        }
        return this.jsonReader.nextBoolean();
    }

    @Override
    public void nextUnknown(ILogger logger, Map<String, Object> unknown, String name) {
        try {
            unknown.put(name, this.nextObjectOrNull());
        }
        catch (Exception exception) {
            logger.log(SentryLevel.ERROR, exception, "Error deserializing unknown key: %s", name);
        }
    }

    @Override
    @Nullable
    public <T> List<T> nextListOrNull(@NotNull ILogger logger, @NotNull JsonDeserializer<T> deserializer) throws IOException {
        if (this.jsonReader.peek() == JsonToken.NULL) {
            this.jsonReader.nextNull();
            return null;
        }
        this.jsonReader.beginArray();
        ArrayList<T> list = new ArrayList<T>();
        if (this.jsonReader.hasNext()) {
            do {
                try {
                    list.add(deserializer.deserialize(this, logger));
                }
                catch (Exception e) {
                    logger.log(SentryLevel.WARNING, "Failed to deserialize object in list.", e);
                }
            } while (this.jsonReader.peek() == JsonToken.BEGIN_OBJECT);
        }
        this.jsonReader.endArray();
        return list;
    }

    @Override
    @Nullable
    public <T> Map<String, T> nextMapOrNull(@NotNull ILogger logger, @NotNull JsonDeserializer<T> deserializer) throws IOException {
        if (this.jsonReader.peek() == JsonToken.NULL) {
            this.jsonReader.nextNull();
            return null;
        }
        this.jsonReader.beginObject();
        HashMap<String, T> map = new HashMap<String, T>();
        if (this.jsonReader.hasNext()) {
            do {
                try {
                    String key = this.jsonReader.nextName();
                    map.put(key, deserializer.deserialize(this, logger));
                }
                catch (Exception e) {
                    logger.log(SentryLevel.WARNING, "Failed to deserialize object in map.", e);
                }
            } while (this.jsonReader.peek() == JsonToken.BEGIN_OBJECT || this.jsonReader.peek() == JsonToken.NAME);
        }
        this.jsonReader.endObject();
        return map;
    }

    @Override
    @Nullable
    public <T> Map<String, List<T>> nextMapOfListOrNull(@NotNull ILogger logger, @NotNull JsonDeserializer<T> deserializer) throws IOException {
        if (this.peek() == JsonToken.NULL) {
            this.nextNull();
            return null;
        }
        @NotNull HashMap<String, List<T>> result = new HashMap<String, List<T>>();
        this.beginObject();
        if (this.hasNext()) {
            do {
                @NotNull String key = this.nextName();
                @Nullable List<T> list = this.nextListOrNull(logger, deserializer);
                if (list == null) continue;
                result.put(key, list);
            } while (this.peek() == JsonToken.BEGIN_OBJECT || this.peek() == JsonToken.NAME);
        }
        this.endObject();
        return result;
    }

    @Override
    @Nullable
    public <T> T nextOrNull(@NotNull ILogger logger, @NotNull JsonDeserializer<T> deserializer) throws Exception {
        if (this.jsonReader.peek() == JsonToken.NULL) {
            this.jsonReader.nextNull();
            return null;
        }
        return deserializer.deserialize(this, logger);
    }

    @Override
    @Nullable
    public Date nextDateOrNull(ILogger logger) throws IOException {
        if (this.jsonReader.peek() == JsonToken.NULL) {
            this.jsonReader.nextNull();
            return null;
        }
        return ObjectReader.dateOrNull(this.jsonReader.nextString(), logger);
    }

    @Override
    @Nullable
    public TimeZone nextTimeZoneOrNull(ILogger logger) throws IOException {
        if (this.jsonReader.peek() == JsonToken.NULL) {
            this.jsonReader.nextNull();
            return null;
        }
        try {
            return TimeZone.getTimeZone(this.jsonReader.nextString());
        }
        catch (Exception e) {
            logger.log(SentryLevel.ERROR, "Error when deserializing TimeZone", e);
            return null;
        }
    }

    @Override
    @Nullable
    public Object nextObjectOrNull() throws IOException {
        return new JsonObjectDeserializer().deserialize(this);
    }

    @Override
    @NotNull
    public JsonToken peek() throws IOException {
        return this.jsonReader.peek();
    }

    @Override
    @NotNull
    public String nextName() throws IOException {
        return this.jsonReader.nextName();
    }

    @Override
    public void beginObject() throws IOException {
        this.jsonReader.beginObject();
    }

    @Override
    public void endObject() throws IOException {
        this.jsonReader.endObject();
    }

    @Override
    public void beginArray() throws IOException {
        this.jsonReader.beginArray();
    }

    @Override
    public void endArray() throws IOException {
        this.jsonReader.endArray();
    }

    @Override
    public boolean hasNext() throws IOException {
        return this.jsonReader.hasNext();
    }

    @Override
    public int nextInt() throws IOException {
        return this.jsonReader.nextInt();
    }

    @Override
    public long nextLong() throws IOException {
        return this.jsonReader.nextLong();
    }

    @Override
    public String nextString() throws IOException {
        return this.jsonReader.nextString();
    }

    @Override
    public boolean nextBoolean() throws IOException {
        return this.jsonReader.nextBoolean();
    }

    @Override
    public double nextDouble() throws IOException {
        return this.jsonReader.nextDouble();
    }

    @Override
    public void nextNull() throws IOException {
        this.jsonReader.nextNull();
    }

    @Override
    public void setLenient(boolean lenient) {
        this.jsonReader.setLenient(lenient);
    }

    @Override
    public void skipValue() throws IOException {
        this.jsonReader.skipValue();
    }

    @Override
    public void close() throws IOException {
        this.jsonReader.close();
    }
}

